<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package mykd
 */

$mykd_show_blog_share = get_theme_mod('mykd_show_blog_share', false);
$mykd_post_tags_width = $mykd_show_blog_share ? 'col-md-7' : 'col-12';

?>
<?php if (is_single()) : ?>

    <article id="post-<?php the_ID(); ?>" <?php post_class('blog-post-item blog-details-wrap format-image'); ?>>

        <?php if (has_post_thumbnail()) : ?>
            <div class="blog-post-thumb">
                <?php the_post_thumbnail('full', ['class' => 'img-responsive']); ?>
            </div>
        <?php endif; ?>

        <div class="blog-details-content">

            <!-- blog meta -->
            <div class="blog-post-meta">
                <?php get_template_part('template-parts/blog/blog-meta'); ?>
            </div>

            <div class="post-text">
                <?php the_content(); ?>
                <?php
                wp_link_pages([
                    'before'      => '<div class="page-links">' . esc_html__('Pages:', 'mykd'),
                    'after'       => '</div>',
                    'link_before' => '<span class="page-number">',
                    'link_after'  => '</span>',
                ]);
                ?>
            </div>

            <?php if (!empty(get_the_tags())) : ?>
                <div class="blog-details-bottom">

                    <div class="row">
                        <div class="<?php echo esc_attr($mykd_post_tags_width); ?>">
                            <?php print mykd_get_tag(); ?>
                        </div>
                        <?php if (!empty($mykd_show_blog_share)) : ?>
                            <div class="col-md-5">
                                <div class="blog-post-share justify-content-start justify-content-md-end">
                                    <h5 class="share"><?php echo esc_html__('share :', 'mykd') ?></h5>
                                    <?php mykd_social_share(); ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>

                </div>
            <?php endif; ?>

        </div>
    </article>

<?php else : ?>

    <article id="post-<?php the_ID(); ?>" <?php post_class('blog-post-item format-image'); ?>>

        <?php if (has_post_thumbnail()) : ?>
            <div class="blog-post-thumb">
                <a href="<?php the_permalink(); ?>">
                    <?php the_post_thumbnail('full', ['class' => 'img-responsive']); ?>
                </a>
            </div>
        <?php endif; ?>

        <div class="blog-post-content">

            <!-- blog meta -->
            <div class="blog-post-meta">
                <?php get_template_part('template-parts/blog/blog-meta'); ?>
            </div>
            <h2 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
            <div class="post-text">
                <p><?php print wp_trim_words(get_the_excerpt(get_the_ID()), 39, ''); ?></p>
            </div>

            <!-- Blog Bottom -->
            <div class="blog-post-bottom">
                <?php get_template_part('template-parts/blog/blog-btn'); ?>

                <?php if (!empty($mykd_show_blog_share)) : ?>
                    <div class="blog-post-share">
                        <h5 class="share"><?php echo esc_html__('Share :', 'mykd') ?></h5>
                        <?php mykd_social_share(); ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </article>

<?php endif; ?>