<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package mykd
 */
?>

<!doctype html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <?php if (is_singular() && pings_open(get_queried_object())) : ?>
    <?php endif; ?>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

    <?php wp_body_open(); ?>


    <?php
    $mykd_backtotop = get_theme_mod('mykd_backtotop', false);
    $mykd_clickSound = get_theme_mod('mykd_clickSound', false);
    ?>

    <?php if (!empty($mykd_clickSound)) : ?>
        <script>
            jQuery(document).ready(function($) {
                /*===========================================
                    =        Click Sound Active		      =
                =============================================*/
                $('.search a, .tg-btn-1, .side-toggle-icon, .mobile-nav-toggler, .dropdown-btn').on('click', () => new Audio('<?php echo get_template_directory_uri(); ?>/assets/audio/click.wav').play());
                $('.search__close, .offCanvas__toggle, .offCanvas__overlay, .close-btn').on('click', () => new Audio('<?php echo get_template_directory_uri(); ?>/assets/audio/remove.wav').play());
            });
        </script>
    <?php endif; ?>

    <?php if (!empty($mykd_backtotop)) : ?>
        <!-- Scroll-top -->
        <button class="scroll__top scroll-to-target" data-target="html">
            <i class="flaticon-right-arrow"></i>
        </button>
        <!-- Scroll-top-end-->
    <?php endif; ?>


    <?php do_action('mykd_header_style'); ?>


    <!-- main-area -->
    <main class="main-area">

        <?php do_action('mykd_before_main_content'); ?>