<?php

/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.4.0
 */

$shop_column = is_active_sidebar('product-sidebar') ? 'col-xl-9 col-lg-8 col-md-12 col-sm-8' : 'col-12';

defined('ABSPATH') || exit;

get_header('shop');
?>

<?php

/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
do_action('woocommerce_before_main_content');

?>


<div class="row justify-content-center">

    <?php if (is_active_sidebar('product-sidebar')) : ?>
        <div class="col-xl-3 col-lg-4 col-md-11 order-2 order-lg-0">
            <aside class="shop-sidebar">
                <?php dynamic_sidebar('product-sidebar'); ?>
            </aside>
        </div>
    <?php endif; ?>

    <div class="<?php print esc_attr($shop_column); ?>">

        <?php
        /**
         * Hook: woocommerce_archive_description.
         *
         * @hooked woocommerce_taxonomy_archive_description - 10
         * @hooked woocommerce_product_archive_description - 10
         */
        do_action('woocommerce_archive_description');
        ?>
        <?php
        if (woocommerce_product_loop()) {

        ?>
            <div class="shop__top-wrap">
                <div class="row align-items-center">
                    <div class="col-xl-8 col-sm-6">
                        <div class="shop__showing-result">
                            <?php
                            /**
                             * Hook: woocommerce_before_shop_loop.
                             *
                             * @hooked woocommerce_output_all_notices - 10
                             * @hooked woocommerce_result_count - 20
                             * @hooked woocommerce_catalog_ordering - 30
                             */
                            do_action('woocommerce_before_shop_loop');
                            ?>
                        </div>
                    </div>
                    <div class="col-xl-4 col-sm-6">
                        <div class="shop__ordering">
                            <?php woocommerce_catalog_ordering(); ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php

            woocommerce_product_loop_start();

            if (wc_get_loop_prop('total')) {
                while (have_posts()) {
                    the_post();

                    print '<div class="col grid-item grid-sizer">';

                    /**
                     * Hook: woocommerce_shop_loop.
                     */
                    do_action('woocommerce_shop_loop');

                    wc_get_template_part('content', 'product');
                    print '</div>';
                }
            }

            woocommerce_product_loop_end();

            /**
             * Hook: woocommerce_after_shop_loop.
             *
             * @hooked woocommerce_pagination - 10
             */
            do_action('woocommerce_after_shop_loop');
        } else {
            /**
             * Hook: woocommerce_no_products_found.
             *
             * @hooked wc_no_products_found - 10
             */
            do_action('woocommerce_no_products_found');
        }

        ?>
    </div>

    <?php
    /**
     * Hook: woocommerce_after_main_content.
     *
     * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
     */
    do_action('woocommerce_after_main_content');
    ?>

    <?php

    ?>
</div>
<?php

get_footer('shop');
