<?php

/**
 * Template part for displaying offcanvas menu
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package mykd
*/

$offcanvas_title = get_theme_mod('offcanvas_title', __('Best Seller of Month Ideas for <span>NFT Wallet</span>', 'mykd'));

$offcanvas_address_show = get_theme_mod('offcanvas_address_show', false);
$offcanvas_address_title = get_theme_mod('offcanvas_address_title', __('CONTACT US', 'mykd'));
$offcanvas_phone_text = get_theme_mod('offcanvas_phone_text', __('+9 333 222 5557', 'mykd'));
$offcanvas_email_text = get_theme_mod('offcanvas_email_text', __('info@webmail.com', 'mykd'));
$offcanvas_address_text = get_theme_mod('offcanvas_address_text', __('New Central Park W7 Street ,New York', 'mykd'));

// Newsletter
$mykd_show_offcanvas_newsletter = get_theme_mod('mykd_show_offcanvas_newsletter', false);
$offcanvas_newsletter_title = get_theme_mod('offcanvas_newsletter_title', __('Subscribe', 'mykd'));
$offcanvas_shortcode = get_theme_mod('offcanvas_shortcode', __('', 'mykd'));
$offcanvas_newsletter_desc = get_theme_mod('offcanvas_newsletter_desc', __('Subscribe dolor sitamet, consectetur adiping eli. Duis esollici tudin augue.', 'mykd'));

// Social List
$mykd_show_offcanvas_social = get_theme_mod('mykd_show_offcanvas_social', false);
$offcanvas_fb = get_theme_mod('offcanvas_fb', __('#', 'mykd'));
$offcanvas_twitter = get_theme_mod('offcanvas_twitter', __('#', 'mykd'));
$offcanvas_linkedin = get_theme_mod('offcanvas_linkedin', __('#', 'mykd'));
$offcanvas_instagram = get_theme_mod('offcanvas_instagram', __('#', 'mykd'));
$offcanvas_pinterest = get_theme_mod('offcanvas_pinterest', __('#', 'mykd'));
$offcanvas_youtube = get_theme_mod('offcanvas_youtube', __('#', 'mykd'));

// Copyright Text
$offcanvas_copyright_title = get_theme_mod('offcanvas_copyright_title', __('Copyright © 2023 - By <span>MYKD</span>', 'mykd'));

?>


<div class="offCanvas__wrap">
    <div class="offCanvas__body">
        <div class="offCanvas__top">
            <div class="offCanvas__logo logo">
                <?php mykd_header_logo(); ?>
            </div>
            <div class="offCanvas__toggle">
                <i class="far fa-hand-point-up"></i>
            </div>
        </div>
        <div class="offCanvas__content">
            <?php if (!empty($offcanvas_title)) : ?>
                <h2 class="title"><?php echo wp_kses_post($offcanvas_title); ?></h2>
            <?php endif; ?>

            <?php if (!empty($offcanvas_address_show)) : ?>
                <div class="offCanvas__contact">
                    <?php if (!empty($offcanvas_address_title)) : ?>
                        <h4 class="small-title"><?php echo wp_kses_post($offcanvas_address_title); ?></h4>
                    <?php endif; ?>
                    <ul class="offCanvas__contact-list list-wrap">

                        <?php if (!empty($offcanvas_phone_text)) : ?>
                            <li><a href="tel:<?php echo esc_attr($offcanvas_phone_text); ?>"><?php echo wp_kses_post($offcanvas_phone_text); ?></a></li>
                        <?php endif; ?>

                        <?php if (!empty($offcanvas_email_text)) : ?>
                            <li><a href="mailto:<?php echo esc_attr($offcanvas_email_text); ?>"><?php echo wp_kses_post($offcanvas_email_text); ?></a></li>
                        <?php endif; ?>

                        <?php if (!empty($offcanvas_address_text)) : ?>
                            <li><?php echo wp_kses_post($offcanvas_address_text); ?></li>
                        <?php endif; ?>
                    </ul>
                </div>
            <?php endif; ?>

            <?php if (!empty($mykd_show_offcanvas_newsletter)) : ?>
                <div class="offCanvas__newsletter">
                    <?php if (!empty($offcanvas_newsletter_title)) : ?>
                        <h4 class="small-title"><?php echo wp_kses_post($offcanvas_newsletter_title); ?></h4>
                    <?php endif; ?>

                    <?php if (!empty($offcanvas_shortcode)) : ?>
                        <?php echo do_shortcode($offcanvas_shortcode); ?>
                    <?php endif; ?>

                    <?php if (!empty($offcanvas_newsletter_desc)) : ?>
                        <p><?php echo wp_kses_post($offcanvas_newsletter_desc); ?></p>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

            <?php if (!empty($mykd_show_offcanvas_social)) : ?>
                <ul class="offCanvas__social list-wrap">
                    <?php if (!empty($offcanvas_fb)) : ?>
                        <li>
                            <a href="<?php echo esc_url($offcanvas_fb); ?>"><i class="fab fa-twitter"></i></a>
                        </li>
                    <?php endif; ?>

                    <?php if (!empty($offcanvas_twitter)) : ?>
                        <li>
                            <a href="<?php echo esc_url($offcanvas_twitter); ?>"><i class="fab fa-facebook-f"></i></a>
                        </li>
                    <?php endif; ?>

                    <?php if (!empty($offcanvas_linkedin)) : ?>
                        <li>
                            <a href="<?php echo esc_url($offcanvas_linkedin); ?>"><i class="fab fa-linkedin-in"></i></a>
                        </li>
                    <?php endif; ?>

                    <?php if (!empty($offcanvas_instagram)) : ?>
                        <li>
                            <a href="<?php echo esc_url($offcanvas_instagram); ?>"><i class="fab fa-instagram"></i></a>
                        </li>
                    <?php endif; ?>

                    <?php if (!empty($offcanvas_pinterest)) : ?>
                        <li>
                            <a href="<?php echo esc_url($offcanvas_pinterest); ?>"><i class="fab fa-pinterest-p"></i></a>
                        </li>
                    <?php endif; ?>

                    <?php if (!empty($offcanvas_youtube)) : ?>
                        <li>
                            <a href="<?php echo esc_url($offcanvas_youtube); ?>"><i class="fab fa-youtube"></i></a>
                        </li>
                    <?php endif; ?>
                </ul>
            <?php endif; ?>
        </div>

        <?php if (!empty($offcanvas_copyright_title)) : ?>
            <div class="offCanvas__copyright">
                <p><?php echo wp_kses_post($offcanvas_copyright_title); ?></p>
            </div>
        <?php endif; ?>

    </div>
</div>
<div class="offCanvas__overlay"></div>