<?php

/**
 * Template part for displaying header layout one
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package mykd
 */

// Header Settings
$mykd_show_sticky_header = get_theme_mod('mykd_show_sticky_header', false);
$sticky_header = $mykd_show_sticky_header ? 'sticky-header' : 'sticky-default';
$sticky_height = $mykd_show_sticky_header ? '' : 'd-none';

$menu_padding = has_nav_menu('main-menu') ? 'mykd-menu-has-showing' : 'mykd-menu-not-showing';

// Header Button
$mykd_show_header_right = get_theme_mod('mykd_show_header_right', false);
$mykd_show_header_search = get_theme_mod('mykd_show_header_search', false);
$mykd_show_header_button = get_theme_mod('mykd_show_header_button', false);
$mykd_header_btn_text = get_theme_mod('mykd_header_btn_text', __('~sing in', 'mykd'));
$mykd_header_btn_icon = get_theme_mod('mykd_header_btn_icon', __('<i class="flaticon-edit"></i>', 'mykd'));
$mykd_header_btn_url = get_theme_mod('mykd_header_btn_url', __('#', 'mykd'));

$mykd_show_offcanvas = get_theme_mod('mykd_show_offcanvas', false);

// Mobile Menu
$mykd_show_mobile_search = get_theme_mod('mykd_show_mobile_search', false);
$mykd_show_mobile_social = get_theme_mod('mykd_show_mobile_social', false);

?>

<!-- header-area -->
<header>
    <div id="<?php echo esc_attr($sticky_header); ?>" class="tg-header__area transparent-header <?php echo esc_attr($menu_padding) ?>">
        <div class="container custom-container">
            <div class="row">
                <div class="col-12">
                    <div class="tgmenu__wrap">
                        <nav class="tgmenu__nav">
                            <div class="logo">
                                <?php mykd_header_logo(); ?>
                            </div>
                            <div class="tgmenu__navbar-wrap tgmenu__main-menu d-none d-xl-flex">
                                <?php mykd_header_menu(); ?>
                            </div>
                            <?php if (!empty($mykd_show_header_right)) : ?>
                                <div class="tgmenu__action d-none d-md-block">
                                    <ul class="list-wrap">

                                        <?php if (!empty($mykd_show_header_search)) : ?>
                                            <li class="search">
                                                <a href="javascript:void(0)"><i class="flaticon-search-1"></i></a>
                                            </li>
                                        <?php endif; ?>

                                        <?php if (!empty($mykd_show_header_button)) : ?>
                                            <li class="header-btn">
                                                <a href="<?php echo esc_url($mykd_header_btn_url) ?>" class="tg-border-btn">
                                                    <?php echo wp_kses_post($mykd_header_btn_icon); ?>
                                                    <?php echo esc_html($mykd_header_btn_text); ?>
                                                </a>
                                            </li>
                                        <?php endif; ?>

                                        <?php if (!empty($mykd_show_offcanvas)) : ?>
                                            <li class="side-toggle-icon">
                                                <span></span>
                                                <span></span>
                                                <span></span>
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            <?php endif; ?>

                            <?php if (has_nav_menu('main-menu')) { ?>
                                <div class="mobile-nav-toggler"><i class="fas fa-bars"></i></div>
                            <?php } ?>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Mobile Menu  -->
    <div class="tgmobile__menu">
        <nav class="tgmobile__menu-box">
            <div class="close-btn"><i class="far fa-hand-point-up"></i></div>
            <div class="nav-logo">
                <?php mykd_header_logo(); ?>
            </div>

            <?php if (!empty($mykd_show_mobile_search)) : ?>
                <div class="tgmobile__search">
                    <form method="get" action="<?php print esc_url(home_url('/')); ?>">
                        <input type="text" name="s" value="<?php print esc_attr(get_search_query()) ?>" placeholder="<?php print esc_attr__('Search here...', 'mykd'); ?>">
                        <button type="submit"><i class="flaticon-loupe"></i></button>
                    </form>
                </div>
            <?php endif; ?>

            <div class="tgmobile__menu-outer">
                <!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header-->
            </div>
            <?php if (!empty($mykd_show_mobile_social)) : ?>
                <div class="social-links">
                    <?php mykd_mobile_social_profiles(); ?>
                </div>
            <?php endif; ?>
        </nav>
    </div>
    <div class="tgmobile__menu-backdrop"></div>
    <!-- End Mobile Menu -->

    <?php if (!empty($mykd_show_header_search)) : ?>
        <!-- header-search -->
        <?php get_template_part('template-parts/header/header-search'); ?>
        <!-- header-search-end -->
    <?php endif; ?>


    <?php if (!empty($mykd_show_offcanvas)) : ?>
        <!-- offCanvas-menu -->
        <?php get_template_part('template-parts/header/header-offcanvas'); ?>
        <!-- offCanvas-menu-end -->
    <?php endif; ?>

</header>
<!-- header-area-end -->