<?php
/**
 * mykd customizer
 *
 * @package mykd
 */

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Added Panels & Sections
 */
function mykd_customizer_panels_sections( $wp_customize ) {

    //Add panel
    $wp_customize->add_panel( 'mykd_customizer', [
        'priority' => 10,
        'title'    => esc_html__( 'Mykd Customizer', 'mykd' ),
    ] );

    /**
     * Customizer Section
     */
    $wp_customize->add_section( 'mykd_default_setting', [
        'title'       => esc_html__( 'Mykd Default Setting', 'mykd' ),
        'description' => '',
        'priority'    => 10,
        'capability'  => 'edit_theme_options',
        'panel'       => 'mykd_customizer',
    ] );

    $wp_customize->add_section('section_header_logo', [
        'title'       => esc_html__('Header Setting', 'mykd'),
        'description' => '',
        'priority'    => 11,
        'capability'  => 'edit_theme_options',
        'panel'       => 'mykd_customizer',
    ]);

    $wp_customize->add_section( 'header_top_setting', [
        'title'       => esc_html__( 'Header Top Setting', 'mykd' ),
        'description' => '',
        'priority'    => 12,
        'capability'  => 'edit_theme_options',
        'panel'       => 'mykd_customizer',
    ] );

    $wp_customize->add_section( 'header_info_setting', [
        'title'       => esc_html__( 'Header Right Setting', 'mykd' ),
        'description' => '',
        'priority'    => 13,
        'capability'  => 'edit_theme_options',
        'panel'       => 'mykd_customizer',
    ] );

    $wp_customize->add_section( 'offcanvas_setting', [
        'title'       => esc_html__( 'Offcanvas Setting', 'mykd' ),
        'description' => '',
        'priority'    => 14,
        'capability'  => 'edit_theme_options',
        'panel'       => 'mykd_customizer',
    ] );

    $wp_customize->add_section( 'mobile_menu_setting', [
        'title'       => esc_html__( 'Mobile Menu Setting', 'mykd' ),
        'description' => '',
        'priority'    => 15,
        'capability'  => 'edit_theme_options',
        'panel'       => 'mykd_customizer',
    ] );

    $wp_customize->add_section( 'breadcrumb_setting', [
        'title'       => esc_html__( 'Breadcrumb Setting', 'mykd' ),
        'description' => '',
        'priority'    => 16,
        'capability'  => 'edit_theme_options',
        'panel'       => 'mykd_customizer',
    ] );

    $wp_customize->add_section( 'blog_setting', [
        'title'       => esc_html__( 'Blog Setting', 'mykd' ),
        'description' => '',
        'priority'    => 17,
        'capability'  => 'edit_theme_options',
        'panel'       => 'mykd_customizer',
    ] );

    $wp_customize->add_section( 'footer_setting', [
        'title'       => esc_html__( 'Footer Settings', 'mykd' ),
        'description' => '',
        'priority'    => 18,
        'capability'  => 'edit_theme_options',
        'panel'       => 'mykd_customizer',
    ] );

    $wp_customize->add_section( 'color_setting', [
        'title'       => esc_html__( 'Color Setting', 'mykd' ),
        'description' => '',
        'priority'    => 19,
        'capability'  => 'edit_theme_options',
        'panel'       => 'mykd_customizer',
    ] );

    $wp_customize->add_section( '404_page', [
        'title'       => esc_html__( '404 Page', 'mykd' ),
        'description' => '',
        'priority'    => 20,
        'capability'  => 'edit_theme_options',
        'panel'       => 'mykd_customizer',
    ] );

    $wp_customize->add_section( 'typo_setting', [
        'title'       => esc_html__( 'Typography Setting', 'mykd' ),
        'description' => '',
        'priority'    => 21,
        'capability'  => 'edit_theme_options',
        'panel'       => 'mykd_customizer',
    ] );

    $wp_customize->add_section( 'slug_setting', [
        'title'       => esc_html__( 'Slug Settings', 'mykd' ),
        'description' => '',
        'priority'    => 22,
        'capability'  => 'edit_theme_options',
        'panel'       => 'mykd_customizer',
    ] );
}

add_action( 'customize_register', 'mykd_customizer_panels_sections' );


/*
Theme Default Settings
*/
function _mykd_default_fields( $fields ) {

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'mykd_preloader',
        'label'    => esc_html__( 'Show Preloader', 'mykd' ),
        'section'  => 'mykd_default_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'mykd' ),
            'off' => esc_html__( 'Disable', 'mykd' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'mykd_cursor_mode',
        'label'    => esc_html__( 'Show Cursor Effect', 'mykd' ),
        'section'  => 'mykd_default_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'mykd' ),
            'off' => esc_html__( 'Disable', 'mykd' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'mykd_clickSound',
        'label'    => esc_html__( 'Click Sound Effect', 'mykd' ),
        'section'  => 'mykd_default_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'mykd' ),
            'off' => esc_html__( 'Disable', 'mykd' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'mykd_backtotop',
        'label'    => esc_html__( 'Show Back to Top', 'mykd' ),
        'section'  => 'mykd_default_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'mykd' ),
            'off' => esc_html__( 'Disable', 'mykd' ),
        ],
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_mykd_default_fields' );


/*
Header Settings
 */
function _header_header_fields( $fields ) {

    // Sticky Header
    $fields[] = [
        'type'     => 'switch',
        'settings' => 'mykd_show_sticky_header',
        'label'    => esc_html__( 'Show Sticky Header', 'mykd' ),
        'section'  => 'section_header_logo',
        'default'  => 0,
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'mykd' ),
            'off' => esc_html__( 'Disable', 'mykd' ),
        ],
    ];

    $fields[] = [
        'type'        => 'radio-image',
        'settings'    => 'choose_default_header',
        'label'       => esc_html__( 'Select Header Style', 'mykd' ),
        'section'     => 'section_header_logo',
        'placeholder' => esc_html__( 'Select an option...', 'mykd' ),
        'priority'    => 10,
        'multiple'    => 1,
        'choices'     => [
            'header-style-1' => get_template_directory_uri() . '/inc/img/header/header-1.png',
            'header-style-2' => get_template_directory_uri() . '/inc/img/header/header-2.png',
        ],
        'default'     => 'header-style-1',
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'logo',
        'label'       => esc_html__( 'Header Logo', 'mykd' ),
        'description' => esc_html__( 'Upload Your Logo', 'mykd' ),
        'section'     => 'section_header_logo',
        'default'     => get_template_directory_uri() . '/assets/img/logo/logo.png',
    ];

    $fields[] = [
        'type'        => 'dimension',
        'settings'    => 'logo_size_adjust',
		'label'       => esc_html__( 'Logo Size Height', 'mykd' ),
		'description' => esc_html__( 'Adjust your logo size with px', 'mykd' ),
		'section'     => 'section_header_logo',
		'default'     => '40px',
        'choices'     => [
			'accept_unitless' => true,
		],
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_header_header_fields' );


/*
Header Right Settings
*/
function _header_right_fields( $fields ) {

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'mykd_show_header_right',
        'label'    => esc_html__('Show Header Right', 'mykd'),
        'section'  => 'header_info_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'mykd'),
            'off' => esc_html__('Disable', 'mykd'),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'mykd_show_header_search',
        'label'    => esc_html__('Show Header Search', 'mykd'),
        'section'  => 'header_info_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'mykd'),
            'off' => esc_html__('Disable', 'mykd'),
        ],
        'active_callback'  => [
            [
                'setting'  => 'mykd_show_header_right',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'mykd_search_title',
        'label'    => esc_html__('Enter Search Title', 'mykd'),
        'section'  => 'header_info_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'mykd_show_header_search',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'mykd_show_header_right',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('Search Here', 'mykd'),
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'mykd_show_header_button',
        'label'    => esc_html__('Show Header Button', 'mykd'),
        'section'  => 'header_info_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'mykd'),
            'off' => esc_html__('Disable', 'mykd'),
        ],
        'active_callback'  => [
            [
                'setting'  => 'mykd_show_header_right',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'mykd_header_btn_text',
        'label'    => esc_html__('Enter Button Text', 'mykd'),
        'section'  => 'header_info_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'mykd_show_header_button',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'mykd_show_header_right',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('~sing in', 'mykd'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'mykd_header_btn_icon',
        'label'    => esc_html__('Enter Button Icon', 'mykd'),
        'description' => esc_html__('Upload Icon From Font-Awesome v.5', 'mykd'),
        'section'  => 'header_info_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'mykd_show_header_button',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'mykd_show_header_right',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => wp_kses_post('<i class="flaticon-edit"></i>', 'mykd'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'mykd_header_btn_url',
        'label'    => esc_html__('Enter Button URL', 'mykd'),
        'section'  => 'header_info_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'mykd_show_header_button',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'mykd_show_header_right',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('#', 'mykd'),
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_header_right_fields' );


/*
Offcanvas Settings
*/
function _header_offcanvas_fields($fields)
{

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'mykd_show_offcanvas',
        'label'    => esc_html__('Show Offcanvas', 'mykd'),
        'section'  => 'offcanvas_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'mykd'),
            'off' => esc_html__('Disable', 'mykd'),
        ],
    ];

    $fields[] = [
        'type'     => 'textarea',
        'settings' => 'offcanvas_title',
        'label'    => esc_html__('Enter Title', 'mykd'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'default'  => wp_kses_post('Best Seller of Month Ideas for <span>NFT Wallet</span>', 'mykd'),
        'active_callback'  => [
            [
                'setting'  => 'mykd_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    // Offcanvas Address
    $fields[] = [
        'type'     => 'switch',
        'settings' => 'offcanvas_address_show',
        'label'    => esc_html__('Show Address', 'mykd'),
        'section'  => 'offcanvas_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'mykd'),
            'off' => esc_html__('Disable', 'mykd'),
        ],
        'active_callback'  => [
            [
                'setting'  => 'mykd_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'offcanvas_address_title',
        'label'    => esc_html__('Enter Address Text', 'mykd'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'default'  => esc_html__('CONTACT US', 'mykd'),
        'active_callback'  => [
            [
                'setting'  => 'mykd_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'offcanvas_address_show',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'offcanvas_phone_text',
        'label'    => esc_html__('Enter Phone Number', 'mykd'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'default'  => esc_html__('+9 333 222 5557', 'mykd'),
        'active_callback'  => [
            [
                'setting'  => 'mykd_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'offcanvas_address_show',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'offcanvas_email_text',
        'label'    => esc_html__('Enter Email Address', 'mykd'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'default'  => esc_html__('info@webmail.com', 'mykd'),
        'active_callback'  => [
            [
                'setting'  => 'mykd_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'offcanvas_address_show',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'textarea',
        'settings' => 'offcanvas_address_text',
        'label'    => esc_html__('Enter Office Address', 'mykd'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'default'  => esc_html__('New Central Park W7 Street ,New York', 'mykd'),
        'active_callback'  => [
            [
                'setting'  => 'mykd_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'offcanvas_address_show',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    // Offcanvas Newsletter
    $fields[] = [
        'type'     => 'switch',
        'settings' => 'mykd_show_offcanvas_newsletter',
        'label'    => esc_html__('Show Newsletter', 'mykd'),
        'section'  => 'offcanvas_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'mykd'),
            'off' => esc_html__('Disable', 'mykd'),
        ],
        'active_callback'  => [
            [
                'setting'  => 'mykd_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'offcanvas_newsletter_title',
        'label'    => esc_html__('Enter Newsletter Title', 'mykd'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'default'  => esc_html__('Subscribe', 'mykd'),
        'active_callback'  => [
            [
                'setting'  => 'mykd_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'mykd_show_offcanvas_newsletter',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'offcanvas_shortcode',
        'label'    => esc_html__('Enter Newsletter Shortcode', 'mykd'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'default'  => esc_html__('', 'mykd'),
        'active_callback'  => [
            [
                'setting'  => 'mykd_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'mykd_show_offcanvas_newsletter',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'textarea',
        'settings' => 'offcanvas_newsletter_desc',
        'label'    => esc_html__('Enter Newsletter Description', 'mykd'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'default'  => esc_html__('Subscribe dolor sitamet, consectetur adiping eli. Duis esollici tudin augue.', 'mykd'),
        'active_callback'  => [
            [
                'setting'  => 'mykd_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'mykd_show_offcanvas_newsletter',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    // Offcanvas Social
    $fields[] = [
        'type'     => 'switch',
        'settings' => 'mykd_show_offcanvas_social',
        'label'    => esc_html__('Show Offcanvas Social', 'mykd'),
        'section'  => 'offcanvas_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'mykd'),
            'off' => esc_html__('Disable', 'mykd'),
        ],
        'active_callback'  => [
            [
                'setting'  => 'mykd_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'offcanvas_fb',
        'label'    => esc_html__('Enter Facebook url', 'mykd'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'mykd_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'mykd_show_offcanvas_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('#', 'mykd'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'offcanvas_twitter',
        'label'    => esc_html__('Enter Twitter url', 'mykd'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'mykd_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'mykd_show_offcanvas_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('#', 'mykd'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'offcanvas_linkedin',
        'label'    => esc_html__('Enter Linkedin url', 'mykd'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'mykd_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'mykd_show_offcanvas_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('#', 'mykd'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'offcanvas_instagram',
        'label'    => esc_html__('Enter Instagram url', 'mykd'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'mykd_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'mykd_show_offcanvas_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('#', 'mykd'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'offcanvas_pinterest',
        'label'    => esc_html__('Enter Pinterest url', 'mykd'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'mykd_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'mykd_show_offcanvas_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('#', 'mykd'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'offcanvas_youtube',
        'label'    => esc_html__('Enter Youtube url', 'mykd'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'mykd_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'mykd_show_offcanvas_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('#', 'mykd'),
    ];

    // Offcanvas Copyright
    $fields[] = [
        'type'     => 'textarea',
        'settings' => 'offcanvas_copyright_title',
        'label'    => esc_html__('Enter Copyright Text', 'mykd'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'mykd_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => wp_kses_post('Copyright © 2023 - By <span>MYKD</span>', 'mykd'),
    ];

    return $fields;
}
add_filter('kirki/fields', '_header_offcanvas_fields');


/*
Mobile Menu Settings
*/
function _mobile_menu_fields( $fields ) {

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'mykd_show_mobile_search',
        'label'    => esc_html__('Show Mobile Menu Search', 'mykd'),
        'section'  => 'mobile_menu_setting',
        'default'  => 0,
        'priority' => 12,
        'choices'  => [
            'on'  => esc_html__('Enable', 'mykd'),
            'off' => esc_html__('Disable', 'mykd'),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'mykd_show_mobile_social',
        'label'    => esc_html__( 'Show Mobile Menu Social', 'mykd' ),
        'section'  => 'mobile_menu_setting',
        'default'  => 0,
        'priority' => 12,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'mykd' ),
            'off' => esc_html__( 'Disable', 'mykd' ),
        ],
    ];

    // Mobile section social
    $fields[] = [
        'type'     => 'text',
        'settings' => 'mykd_mobile_fb_url',
        'label'    => esc_html__( 'Facebook URL', 'mykd' ),
        'section'  => 'mobile_menu_setting',
        'default'  => esc_html__( '#', 'mykd' ),
        'priority' => 12,
        'active_callback'  => [
            [
                'setting'  => 'mykd_show_mobile_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'mykd_mobile_twitter_url',
        'label'    => esc_html__( 'Twitter URL', 'mykd' ),
        'section'  => 'mobile_menu_setting',
        'default'  => esc_html__( '#', 'mykd' ),
        'priority' => 12,
        'active_callback'  => [
            [
                'setting'  => 'mykd_show_mobile_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'mykd_mobile_instagram_url',
        'label'    => esc_html__( 'Instagram URL', 'mykd' ),
        'section'  => 'mobile_menu_setting',
        'default'  => esc_html__( '#', 'mykd' ),
        'priority' => 12,
        'active_callback'  => [
            [
                'setting'  => 'mykd_show_mobile_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'mykd_mobile_linkedin_url',
        'label'    => esc_html__( 'Linkedin URL', 'mykd' ),
        'section'  => 'mobile_menu_setting',
        'default'  => esc_html__( '#', 'mykd' ),
        'priority' => 12,
        'active_callback'  => [
            [
                'setting'  => 'mykd_show_mobile_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'mykd_mobile_telegram_url',
        'label'    => esc_html__( 'Telegram URL', 'mykd' ),
        'section'  => 'mobile_menu_setting',
        'default'  => esc_html__( '#', 'mykd' ),
        'priority' => 12,
        'active_callback'  => [
            [
                'setting'  => 'mykd_show_mobile_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_mobile_menu_fields' );


/*
_header_page_title_fields
 */
function _header_page_title_fields( $fields ) {

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'breadcrumb_hide_default',
        'label'    => esc_html__( 'Breadcrumb Hide by Default', 'mykd' ),
        'section'  => 'breadcrumb_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'mykd' ),
            'off' => esc_html__( 'Disable', 'mykd' ),
        ],
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'breadcrumb_background',
        'label'       => esc_html__('Breadcrumb Background', 'mykd'),
        'description' => esc_html__('Upload Your Background', 'mykd'),
        'section'     => 'breadcrumb_setting',
        'default'     => get_template_directory_uri() . '/assets/img/bg/breadcrumb_bg02.jpg',
        'active_callback'  => [
            [
                'setting'  => 'breadcrumb_hide_default',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'breadcrumb_info_switch',
        'label'    => esc_html__('Breadcrumb Nav Hide', 'mykd'),
        'section'  => 'breadcrumb_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'mykd'),
            'off' => esc_html__('Disable', 'mykd'),
        ],
        'active_callback'  => [
            [
                'setting'  => 'breadcrumb_hide_default',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'breadcrumb_shape',
        'label'       => esc_html__('Breadcrumb Shape', 'mykd'),
        'description' => esc_html__('Upload Your Shape', 'mykd'),
        'section'     => 'breadcrumb_setting',
        'default'     => get_template_directory_uri() . '/assets/img/others/breadcrumb_img01.png',
        'active_callback'  => [
            [
                'setting'  => 'breadcrumb_hide_default',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_header_page_title_fields' );

/*
Header Social
 */
function _header_blog_fields( $fields ) {
// Blog Setting
    $fields[] = [
        'type'     => 'switch',
        'settings' => 'mykd_blog_btn_switch',
        'label'    => esc_html__( 'Show Blog Button', 'mykd' ),
        'section'  => 'blog_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'mykd' ),
            'off' => esc_html__( 'Disable', 'mykd' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'mykd_blog_cat',
        'label'    => esc_html__( 'Show Blog Category Meta', 'mykd' ),
        'section'  => 'blog_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'mykd' ),
            'off' => esc_html__( 'Disable', 'mykd' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'mykd_blog_author',
        'label'    => esc_html__( 'Show Blog Author Meta', 'mykd' ),
        'section'  => 'blog_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'mykd' ),
            'off' => esc_html__( 'Disable', 'mykd' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'mykd_blog_date',
        'label'    => esc_html__( 'Show Blog Date Meta', 'mykd' ),
        'section'  => 'blog_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'mykd' ),
            'off' => esc_html__( 'Disable', 'mykd' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'mykd_blog_comments',
        'label'    => esc_html__( 'Show Blog Comments Meta', 'mykd' ),
        'section'  => 'blog_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'mykd' ),
            'off' => esc_html__( 'Disable', 'mykd' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'mykd_show_blog_share',
        'label'    => esc_html__( 'Show Blog Share', 'mykd' ),
        'section'  => 'blog_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'mykd' ),
            'off' => esc_html__( 'Disable', 'mykd' ),
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'mykd_blog_btn',
        'label'    => esc_html__( 'Blog Button text', 'mykd' ),
        'section'  => 'blog_setting',
        'default'  => esc_html__( 'Read More', 'mykd' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'breadcrumb_blog_title',
        'label'    => esc_html__( 'Blog Title', 'mykd' ),
        'section'  => 'blog_setting',
        'default'  => esc_html__( 'Blog', 'mykd' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'breadcrumb_blog_title_details',
        'label'    => esc_html__( 'Blog Details Title', 'mykd' ),
        'section'  => 'blog_setting',
        'default'  => esc_html__( 'Blog Details', 'mykd' ),
        'priority' => 10,
    ];
    return $fields;
}
add_filter( 'kirki/fields', '_header_blog_fields' );

/*
Footer
 */
function _header_footer_fields( $fields ) {
    // Footer Setting
    $fields[] = [
        'type'        => 'radio-image',
        'settings'    => 'choose_default_footer',
        'label'       => esc_html__( 'Choose Footer Style', 'mykd' ),
        'section'     => 'footer_setting',
        'default'     => '5',
        'placeholder' => esc_html__( 'Select an option...', 'mykd' ),
        'priority'    => 10,
        'multiple'    => 1,
        'choices'     => [
            'footer-style-1'   => get_template_directory_uri() . '/inc/img/footer/footer-1.png',
        ],
        'default'     => 'footer-style-1',
    ];

    $fields[] = [
        'type'        => 'select',
        'settings'    => 'footer_widget_number',
        'label'       => esc_html__( 'Widget Number', 'mykd' ),
        'section'     => 'footer_setting',
        'default'     => '4',
        'placeholder' => esc_html__( 'Select an option...', 'mykd' ),
        'priority'    => 11,
        'multiple'    => 1,
        'choices'     => [
            '4' => esc_html__( 'Widget Number 4', 'mykd' ),
            '3' => esc_html__( 'Widget Number 3', 'mykd' ),
            '2' => esc_html__( 'Widget Number 2', 'mykd' ),
        ],
    ];

    $fields[] = [
        'type'     => 'textarea',
        'settings' => 'mykd_copyright',
        'label'    => esc_html__( 'CopyRight', 'mykd' ),
        'section'  => 'footer_setting',
        'default'  => esc_html__( 'Copyright © Mykd 2023. All Rights Reserved', 'mykd' ),
        'priority' => 15,
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_header_footer_fields' );

// color
function mykd_color_fields( $fields ) {

    // Color Settings
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'mykd_color_option',
        'label'       => __( 'Primary Color', 'mykd' ),
        'description' => esc_html__('This is a Primary color control.', 'mykd' ),
        'section'     => 'color_setting',
        'default'     => '#45f882',
        'priority'    => 10,
    ];

    // Color Settings
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'mykd_color_option3',
        'label'       => __('Secondary Color', 'mykd'),
        'description' => esc_html__('This is a Secondary color control.', 'mykd'),
        'section'     => 'color_setting',
        'default'     => '#ffbe18',
        'priority'    => 10,
    ];

    // Color Settings
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'mykd_color_option2',
        'label'       => __('Third Color', 'mykd' ),
        'description' => esc_html__('This is a Third color control.', 'mykd' ),
        'section'     => 'color_setting',
        'default'     => '#68fb9a',
        'priority'    => 10,
    ];


    // Color Settings
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'mykd_color_option4',
        'label'       => __('Body Background Color', 'mykd' ),
        'description' => esc_html__('This is a Background color control.', 'mykd' ),
        'section'     => 'color_setting',
        'default'     => '#0f161b',
        'priority'    => 10,
    ];

    return $fields;
}
add_filter( 'kirki/fields', 'mykd_color_fields' );

// 404
function mykd_404_fields( $fields ) {

    // 404 settings
    $fields[] = [
        'type'     => 'text',
        'settings' => 'mykd_error_text',
        'label'    => esc_html__('404 Text', 'mykd'),
        'section'  => '404_page',
        'default'  => esc_html__('404', 'mykd'),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'textarea',
        'settings' => 'mykd_error_title',
        'label'    => esc_html__( 'Not Found Title', 'mykd' ),
        'section'  => '404_page',
        'default'  => esc_html__('Sorry, the page you are looking for could not be found', 'mykd' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'mykd_error_link_text',
        'label'    => esc_html__( '404 Link Text', 'mykd' ),
        'section'  => '404_page',
        'default'  => esc_html__( 'Back To Home', 'mykd' ),
        'priority' => 10,
    ];
    return $fields;
}
add_filter( 'kirki/fields', 'mykd_404_fields' );


/**
 * Added Fields
 */
function mykd_typo_fields( $fields ) {
    // typography settings
    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_body_setting',
        'label'       => esc_html__( 'Body Font', 'mykd' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => ['body', 'p'],
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h_setting',
        'label'       => esc_html__( 'Heading Fonts', 'mykd' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => ['h1', 'h2', 'h3', 'h4', 'h5', 'h6'],
            ],
        ],
    ];

    return $fields;
}

add_filter( 'kirki/fields', 'mykd_typo_fields' );



/**
 * This is a short hand function for getting setting value from customizer
 *
 * @param string $name
 *
 * @return bool|string
 */
function MYKD_THEME_OPTION( $name ) {
    $value = '';
    if ( class_exists( 'mykd' ) ) {
        $value = Kirki::get_option( mykd_get_theme(), $name );
    }

    return apply_filters('MYKD_THEME_OPTION', $value, $name );
}

/**
 * Get config ID
 *
 * @return string
 */
function mykd_get_theme() {
    return 'mykd';
}